#include <dinput.h>



#ifdef __cplusplus

extern "C" {

#endif

////////////////////////////////////////////////////////////////////////////

// ********** Data and types used to create c_dfDIMouse ********************

////////////////////////////////////////////////////////////////////////////



typedef struct {

    LONG  lX;                   // x-axis goes here

    LONG  lY;                   // y-axis goes here

    LONG  lZ;                   // z-axis goes here

    BYTE  bButtonA;             // Mouse button A

    BYTE  bButtonB;             // Mouse button B

    BYTE  bButtonC;             // Mouse button C

    BYTE  bButtonD;             // Mouse button D

} MyMouseData;



static DIOBJECTDATAFORMAT rgodfMouse[ ] = {



  { &GUID_XAxis, FIELD_OFFSET(MyMouseData, lX),

    DIDFT_AXIS | DIDFT_ANYINSTANCE, 0, },

  { &GUID_YAxis, FIELD_OFFSET(MyMouseData, lY),

    DIDFT_AXIS | DIDFT_ANYINSTANCE, 0, },

  { &GUID_ZAxis, FIELD_OFFSET(MyMouseData, lZ),

    DIDFT_AXIS | DIDFT_ANYINSTANCE | DIPROPRANGE_NOMIN, 0, },

  { 0, FIELD_OFFSET(MyMouseData, bButtonA),

    DIDFT_BUTTON | DIDFT_ANYINSTANCE, 0, },

  { 0, FIELD_OFFSET(MyMouseData, bButtonB),

    DIDFT_BUTTON | DIDFT_ANYINSTANCE, 0, },

  { 0, FIELD_OFFSET(MyMouseData, bButtonC),

    DIDFT_BUTTON | DIDFT_ANYINSTANCE | DIPROPRANGE_NOMIN, 0, },

  { 0, FIELD_OFFSET(MyMouseData, bButtonC),

    DIDFT_BUTTON | DIDFT_ANYINSTANCE | DIPROPRANGE_NOMIN, 0, },

};



#define numObjectsMouse (sizeof(rgodfMouse) / sizeof(rgodfMouse[0]))



const DIDATAFORMAT c_dfDIMouse = {

    sizeof(DIDATAFORMAT),       // this structure

    sizeof(DIOBJECTDATAFORMAT), // size of object data format

    DIDF_RELAXIS,               // relative axis coordinates

    sizeof(MyMouseData),        // device data size

    numObjectsMouse,            // number of objects

    rgodfMouse,                 // and here they are

};



// Dummy var to make the dump line up nicely

static unsigned char dummy1[] = {0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,0xDD,};



////////////////////////////////////////////////////////////////////////////

// ********** Data and types used to create c_dfDIKeyboard *****************

////////////////////////////////////////////////////////////////////////////



typedef struct {

    BYTE Keys[256];

} MyKeyboardData;



static DIOBJECTDATAFORMAT rgodfKeyboard[ ] = {



 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x00]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x00<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x01]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x01<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x02]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x02<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x03]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x03<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x04]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x04<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x05]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x05<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x06]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x06<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x07]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x07<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x08]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x08<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x09]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x09<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x0A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x0A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x0B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x0B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x0C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x0C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x0D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x0D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x0E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x0E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x0F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x0F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x10]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x10<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x11]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x11<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x12]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x12<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x13]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x13<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x14]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x14<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x15]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x15<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x16]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x16<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x17]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x17<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x18]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x18<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x19]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x19<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x1A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x1A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x1B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x1B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x1C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x1C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x1D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x1D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x1E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x1E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x1F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x1F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x20]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x20<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x21]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x21<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x22]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x22<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x23]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x23<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x24]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x24<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x25]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x25<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x26]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x26<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x27]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x27<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x28]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x28<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x29]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x29<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x2A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x2A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x2B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x2B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x2C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x2C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x2D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x2D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x2E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x2E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x2F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x2F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x30]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x30<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x31]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x31<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x32]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x32<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x33]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x33<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x34]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x34<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x35]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x35<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x36]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x36<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x37]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x37<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x38]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x38<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x39]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x39<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x3A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x3A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x3B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x3B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x3C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x3C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x3D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x3D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x3E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x3E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x3F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x3F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x40]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x40<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x41]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x41<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x42]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x42<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x43]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x43<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x44]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x44<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x45]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x45<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x46]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x46<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x47]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x47<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x48]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x48<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x49]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x49<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x4A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x4A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x4B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x4B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x4C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x4C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x4D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x4D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x4E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x4E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x4F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x4F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x50]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x50<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x51]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x51<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x52]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x52<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x53]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x53<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x54]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x54<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x55]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x55<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x56]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x56<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x57]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x57<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x58]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x58<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x59]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x59<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x5A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x5A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x5B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x5B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x5C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x5C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x5D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x5D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x5E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x5E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x5F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x5F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x60]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x60<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x61]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x61<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x62]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x62<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x63]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x63<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x64]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x64<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x65]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x65<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x66]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x66<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x67]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x67<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x68]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x68<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x69]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x69<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x6A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x6A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x6B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x6B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x6C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x6C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x6D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x6D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x6E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x6E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x6F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x6F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x70]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x70<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x71]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x71<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x72]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x72<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x73]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x73<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x74]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x74<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x75]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x75<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x76]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x76<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x77]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x77<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x78]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x78<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x79]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x79<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x7A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x7A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x7B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x7B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x7C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x7C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x7D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x7D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x7E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x7E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x7F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x7F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x80]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x80<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x81]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x81<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x82]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x82<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x83]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x83<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x84]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x84<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x85]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x85<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x86]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x86<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x87]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x87<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x88]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x88<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x89]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x89<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x8A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x8A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x8B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x8B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x8C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x8C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x8D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x8D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x8E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x8E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x8F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x8F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x90]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x90<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x91]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x91<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x92]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x92<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x93]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x93<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x94]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x94<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x95]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x95<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x96]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x96<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x97]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x97<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x98]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x98<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x99]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x99<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x9A]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x9A<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x9B]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x9B<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x9C]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x9C<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x9D]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x9D<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x9E]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x9E<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0x9F]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0x9F<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA0]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA0<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA1]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA1<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA2]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA2<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA3]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA3<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA4]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA4<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA5]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA5<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA6]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA6<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA7]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA7<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA8]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA8<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xA9]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xA9<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xAA]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xAA<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xAB]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xAB<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xAC]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xAC<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xAD]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xAD<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xAE]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xAE<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xAF]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xAF<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB0]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB0<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB1]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB1<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB2]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB2<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB3]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB3<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB4]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB4<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB5]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB5<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB6]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB6<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB7]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB7<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB8]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB8<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xB9]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xB9<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xBA]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xBA<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xBB]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xBB<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xBC]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xBC<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xBD]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xBD<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xBE]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xBE<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xBF]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xBF<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC0]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC0<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC1]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC1<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC2]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC2<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC3]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC3<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC4]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC4<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC5]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC5<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC6]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC6<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC7]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC7<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC8]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC8<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xC9]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xC9<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xCA]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xCA<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xCB]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xCB<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xCC]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xCC<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xCD]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xCD<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xCE]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xCE<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xCF]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xCF<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD0]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD0<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD1]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD1<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD2]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD2<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD3]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD3<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD4]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD4<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD5]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD5<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD6]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD6<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD7]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD7<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD8]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD8<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xD9]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xD9<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xDA]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xDA<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xDB]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xDB<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xDC]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xDC<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xDD]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xDD<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xDE]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xDE<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xDF]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xDF<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE0]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE0<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE1]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE1<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE2]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE2<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE3]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE3<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE4]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE4<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE5]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE5<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE6]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE6<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE7]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE7<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE8]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE8<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xE9]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xE9<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xEA]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xEA<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xEB]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xEB<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xEC]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xEC<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xED]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xED<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xEE]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xEE<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xEF]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xEF<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF0]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF0<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF1]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF1<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF2]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF2<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF3]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF3<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF4]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF4<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF5]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF5<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF6]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF6<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF7]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF7<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF8]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF8<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xF9]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xF9<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xFA]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xFA<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xFB]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xFB<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xFC]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xFC<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xFD]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xFD<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xFE]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xFE<<8),0,},

 {&GUID_Key,FIELD_OFFSET(MyKeyboardData,Keys[0xFF]),DIDFT_BUTTON|DIPROPRANGE_NOMIN|(0xFF<<8),0,},

};



#define numObjectsKeyboard (sizeof(rgodfKeyboard) / sizeof(rgodfKeyboard[0]))



const DIDATAFORMAT c_dfDIKeyboard = {

    sizeof(DIDATAFORMAT),       // this structure

    sizeof(DIOBJECTDATAFORMAT), // size of object data format

    DIDF_RELAXIS,               // relative axis coordinates

    sizeof(MyKeyboardData),     // device data size

    numObjectsKeyboard,         // number of objects

    rgodfKeyboard,              // and here they are

};



#ifdef __cplusplus

}

#endif

